% define geometry of earth as sequence of latitude bands

  function f_result = geometry_setup 
  
%--------------------------------------------------------------------------

% global variables

  global num_lat_zones lats lats_frac
  
%--------------------------------------------------------------------------

% number latitude zones

  num_lat_zones = 10;                   

% number degrees in each zone

  zonal_width = 90/num_lat_zones; 
  
% midpoint of each zone
  
  lats = zonal_width/2:zonal_width:90-zonal_width/2; 
  
% midpoint of each zone (in radians)
  
  lats_rad = lats*pi/180;    
  
% half number radians in each zone
  
  delta_rad = (pi/2)/num_lat_zones/2;    
  
% fraction of the surface of sphere in each latitudesitude zone

  lats_frac = sin(lats_rad+delta_rad) - sin(lats_rad-delta_rad);

%--------------------------------------------------------------------------

% EOF