% Super-resolution 
%
% Author: Carlos Fernandez-Granda 
% Email: cfgranda@stanford.edu

function [tfm, XData, YData, UData, VData, focus_size,top_bound,bottom_bound,left_bound,right_bound,X1,Y1,X2,Y2] = compute_transform( img_small,...
    initial_points_small, SRF )

[n1_small_aux n2_small_aux]=size(img_small);
n1_big= n1_small_aux * SRF;
n2_big= n2_small_aux * SRF;

% Upsampling using bicubic interpolation
img = imresize(img_small,[n1_big n2_big]);

% Choose an area of the image
initial_points=SRF.*(initial_points_small);
initial_points=floor(initial_points);
initial_points=floor(initial_points);
focus_size=[initial_points(2, 2)-initial_points(2, 1)+1 initial_points(1, 2)-initial_points(1, 1)+1];
img_center=floor(mean(initial_points, 2));

% Apply TILT to learn the transformation
tic
[Dotau, A, E,f,tfm_matrix, focus_size, error_sign, UData, VData, XData, YData, A_scale,X1,Y1,X2,Y2]=...
    TILT2(uint8(img), 'HOMOGRAPHY', initial_points, 'SAVE_PATH', [], 'DISPLAY_INTER', 1);
toc

% Crop the image
expand_rate=1;
left_bound_aux=ceil(max(initial_points(1, 1)-expand_rate*(initial_points(1, 2)-initial_points(1, 1)), 1));
left_bound = SRF*ceil((left_bound_aux-1)/SRF)+1;
right_bound_aux = floor(min(initial_points(1, 2) + expand_rate*(initial_points(1, 2)-initial_points(1, 1)), size(img, 2)));
right_bound = left_bound + SRF*ceil((right_bound_aux-left_bound)/SRF)-1;
top_bound_aux=ceil(max(initial_points(2, 1)-expand_rate*(initial_points(2, 2)-initial_points(2, 1)), 1));
top_bound = SRF*ceil((top_bound_aux-1)/SRF)+1;
bottom_bound_aux =floor(min(initial_points(2, 2)+expand_rate*(initial_points(2, 2)-initial_points(2, 1)), size(img, 1)));
bottom_bound = top_bound + SRF*ceil((bottom_bound_aux-top_bound)/SRF)-1;
% Make sure that it can be downsampled exactly
n2_small = (right_bound-left_bound+1)/SRF;
n1_small =(bottom_bound-top_bound+1)/SRF;
input_image=img(top_bound:bottom_bound, left_bound:right_bound);
[n_1,n_2]=size(input_image);
center=img_center+[1-left_bound; 1-top_bound];
image_size=size(input_image);
image_center=floor(center);
focus_center=zeros(2, 1);
focus_center(1)=floor((1+focus_size(2))/2);
focus_center(2)=floor((1+focus_size(1))/2);
tfm=fliptform(maketform('projective', tfm_matrix'));