(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     68274,       1570]
NotebookOptionsPosition[     65977,       1488]
NotebookOutlinePosition[     66328,       1503]
CellTagsIndexPosition[     66285,       1500]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "@", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "BumpWave6`"}]}], "Input",
 CellChangeTimes->{{3.705896223717766*^9, 3.70589622382187*^9}}],

Cell[BoxData[{
 RowBox[{"<<", "\"\<dat/Gauss500-700-0.05.mx\>\""}], "\[IndentingNewLine]", 
 RowBox[{"<<", "\"\<dat/Ricker500-700-0.05.mx\>\""}]}], "Input",
 CellChangeTimes->{3.705457041323058*^9, 3.7054571041604333`*^9, 
  3.7058962215957336`*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Sparse", " ", "proof", " ", "parameters"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7078576872148547`*^9, 3.7078576913518243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"gammaLowG", " ", "=", " ", "0.065"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gammaHighG", "=", "0.2375"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DeltaG", "=", "3.751"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gammaLowR", " ", "=", " ", ".0775"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gammaHighR", "=", ".165"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DeltaR", " ", "=", " ", "5.056"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"betaFac", "[", "isGaussian_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{"isGaussian", ",", "1", ",", 
     RowBox[{"3", "-", 
      RowBox[{"gammaLowR", "^", "2"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.70543955598147*^9, 3.7054395630562677`*^9}, {
  3.705459208298235*^9, 3.7054592569359426`*^9}, {3.7054594079149275`*^9, 
  3.7054594424801216`*^9}, {3.705459501292626*^9, 3.7054595297519555`*^9}, {
  3.7054603711340237`*^9, 3.7054603949619055`*^9}, {3.7054611381446333`*^9, 
  3.705461139147617*^9}, {3.707212287956075*^9, 3.7072122890701637`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Bounds", " ", "on", " ", "constants", " ", "in", " ", "proof", " ", 
   RowBox[{"(", 
    RowBox[{"eta", " ", "is", " ", "psi", " ", "in", " ", "proof"}], ")"}]}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7078577008209224`*^9, 3.707857739360914*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "etaG", ",", "zetaG", ",", "alphaG", ",", "betaG", ",", "alphaRhoG", ",", 
    "alphajG", ",", "QsiG", ",", "gammaLowTrueG", ",", "gammaHighTrueG", ",", 
    "DeltaTrueG"}], "}"}], " ", "=", " ", 
  RowBox[{"computeSparseValues", "[", 
   RowBox[{
   "funListGauss", ",", "gammaLowG", ",", "gammaHighG", ",", "gammaWidthG", 
    ",", "DeltaG", ",", "DeltaWidthG", ",", "numDeltaG", ",", "lambdaG", ",", 
    "epsG", ",", "True"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.705439360644869*^9, 3.705439548223997*^9}, {
   3.7054592953728647`*^9, 3.7054592972015963`*^9}, {3.7054593619227753`*^9, 
   3.7054593639056773`*^9}, {3.7058963160314054`*^9, 3.705896320643835*^9}, 
   3.707857865197789*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0873170041168816`", ",", "0.08731700411688154`", ",", 
   "1.0920631338619997`", ",", "0.11882433796466975`", ",", 
   "0.004746129745118267`", ",", "0.9079368661380002`", ",", 
   "1.3986246737357573`", ",", "0.064`", ",", "0.23800000000000002`", ",", 
   "3.7485714285714287`"}], "}"}]], "Output",
 CellChangeTimes->{3.705456748480815*^9, 3.7054593344463673`*^9, 
  3.705459377509736*^9, 3.705459532690767*^9, 3.705461504975936*^9, 
  3.70589632360468*^9, 3.7072124728416367`*^9, 3.707857808282103*^9, 
  3.707857871043395*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "etaR", ",", "zetaR", ",", "alphaR", ",", "betaR", ",", "alphaRhoR", ",", 
    "alphajR", ",", "QsiR", ",", "gammaLowTrueR", ",", "gammaHighTrueR", ",", 
    "DeltaTrueR"}], "}"}], " ", "=", " ", 
  RowBox[{"computeSparseValues", "[", 
   RowBox[{
   "funListRicker", ",", "gammaLowR", ",", "gammaHighR", ",", "gammaWidthR", 
    ",", "DeltaR", ",", "DeltaWidthR", ",", "numDeltaR", ",", "lambdaR", ",", 
    "epsR", ",", "False"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7054593725389767`*^9, 3.705459374775109*^9}, {
  3.7058963278978004`*^9, 3.7058963329616833`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.1259680918215957`", ",", "0.12596809182159577`", ",", 
   "1.1263231147336656`", ",", "0.26106850312169455`", ",", 
   "0.0003550229120698015`", ",", "0.8736768852663345`", ",", 
   "1.1935160541835517`", ",", "0.077`", ",", "0.16519999999999999`", ",", 
   "5.051428571428572`"}], "}"}]], "Output",
 CellChangeTimes->{3.705459381227294*^9, 3.705459412627451*^9, 
  3.7054594451607203`*^9, 3.7054615071360097`*^9, 3.7058963340587177`*^9, 
  3.7078578086204486`*^9, 3.707857871415752*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"waveBoundG", " ", "=", " ", 
  RowBox[{"betaG", "*", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"gammaLowG", "^", "2"}], "/", "2"}], "]"}], "/", "gammaLowG"}],
     "/", 
    RowBox[{"betaFac", "[", "True", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.705460252031612*^9, 3.7054602908579044`*^9}, {
  3.705460403442045*^9, 3.7054604076390758`*^9}}],

Cell[BoxData["1.8319326107923997`"], "Output",
 CellChangeTimes->{3.7054602927197056`*^9, 3.705460408302695*^9, 
  3.705896339835289*^9, 3.7072122963911915`*^9, 3.707212756611186*^9, 
  3.7078578086314383`*^9, 3.707857871433754*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"waveBoundR", " ", "=", " ", 
  RowBox[{"betaR", "*", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"gammaHighR", "^", "2"}], "/", "2"}], "]"}], "/", 
     "gammaLowR"}], "/", 
    RowBox[{"betaFac", "[", "False", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7054603002709584`*^9, 3.705460304457987*^9}, {
  3.7054603544019485`*^9, 3.705460355087589*^9}, {3.7054604118301015`*^9, 
  3.705460415281397*^9}, {3.7054611436929607`*^9, 3.705461144850092*^9}}],

Cell[BoxData["1.140548403122083`"], "Output",
 CellChangeTimes->{3.7054603048613515`*^9, 3.705460416378451*^9, 
  3.7054611498919144`*^9, 3.7058963423396993`*^9, 3.7072122979857073`*^9, 
  3.707212759584025*^9, 3.7078578086414657`*^9, 3.7078578714517727`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BoundListSparseG", " ", "=", " ", 
   RowBox[{"makeMaxSparseBoundList", "[", 
    RowBox[{
    "funListGauss", ",", "gammaLowG", ",", "gammaHighG", ",", "gammaWidthG", 
     ",", "DeltaG", ",", "DeltaWidthG", ",", "numDeltaG", ",", "lambdaG", ",",
      "epsG", ",", "True"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BoundListSparseR", " ", "=", " ", 
   RowBox[{"makeMaxSparseBoundList", "[", 
    RowBox[{
    "funListRicker", ",", "gammaLowR", ",", "gammaHighR", ",", "gammaWidthR", 
     ",", "DeltaR", ",", "DeltaWidthR", ",", "numDeltaR", ",", "lambdaR", ",",
      "epsR", ",", "False"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7054624884344473`*^9, 3.705462516049968*^9}, {
  3.7054625679358177`*^9, 3.7054626036360884`*^9}, {3.7054633424336524`*^9, 
  3.7054633500409565`*^9}, {3.7054636992523317`*^9, 3.7054637104180565`*^9}, {
  3.7058963679562984`*^9, 3.7058963876702304`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Test", " ", "for", " ", "success", " ", "of", " ", "sparse", " ", 
   "proof"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7078577745847397`*^9, 3.7078577791201005`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "SQG", ",", "SDQG", ",", "SDDQG", ",", "ASG", ",", "ADSG", ",", "ADDSG"}],
     "}"}], " ", "=", " ", 
   RowBox[{"makeSparseQData", "[", "BoundListSparseG", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "SQR", ",", "SDQR", ",", "SDDQR", ",", "ASR", ",", "ADSR", ",", "ADDSR"}],
     "}"}], " ", "=", " ", 
   RowBox[{"makeSparseQData", "[", "BoundListSparseR", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.705463911666336*^9, 3.705463925286416*^9}, {
  3.7054641633540554`*^9, 3.705464168541041*^9}, {3.7054642021833315`*^9, 
  3.705464242622183*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isSuccessSparse", "[", "BoundListSparseG", "]"}]], "Input",
 CellChangeTimes->{{3.7054657605289745`*^9, 3.705465767895049*^9}, {
  3.705896643440873*^9, 3.7058966441685705`*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.7054657694164915`*^9, {3.705896635815525*^9, 3.70589664481517*^9}, 
   3.7072128852026935`*^9, 3.707857855917858*^9, 3.707857917173691*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isSuccessSparse", "[", "BoundListSparseR", "]"}]], "Input",
 CellChangeTimes->{{3.7054657732762175`*^9, 3.7054657734353714`*^9}, {
  3.7058966483716087`*^9, 3.7058966504285593`*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.705465773740646*^9, 3.70589665084496*^9, 
  3.707212886931347*^9, 3.7078578559288874`*^9, 3.707857917188699*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plotBoundListSparse", "[", "BoundListSparseG", "]"}]], "Input",
 CellChangeTimes->{{3.705463369931033*^9, 3.7054633758107014`*^9}, {
  3.7058966556956406`*^9, 3.705896656327248*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011111111111111112`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw9zQ081Akex/F/UnfdpbJKq5z1sKynhGypVb6s58cxhmFijJnpYtujlJ4x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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011111111111111112`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw1lg801Okaxyebtdqomwhr25FNNd1KSyxJX2siFitmxhhi/qjrOoVkU7PX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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.011111111111111112`], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw1zQk41Ikfx/EpSjatFDq0GkdirSHK0ZKPO+Qet2FmTH9/6VnbZsPaY1bZ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         "]]}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, AxesOrigin -> {0, 0}, 
     PlotRange -> {{0, 164.}, {-0.44618321966851465`, 1.395982606290615}}, 
     PlotRangeClipping -> True, ImagePadding -> All, DisplayFunction -> 
     Identity, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0, 164.}, {-0.44618321966851465`, 1.395982606290615}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"\"Q\"", "\"DQ\"", "\"DDQ\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.2], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.2], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.2], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.2], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.2], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.2], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011111111111111112`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011111111111111112`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011111111111111112`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7054633771269436`*^9, 3.705463741200618*^9, 3.705463779364272*^9, {
   3.7058966568237*^9, 3.7058966837585683`*^9}, 3.7072128897610483`*^9, 
   3.707857856032962*^9, 3.707857917272794*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plotBoundListSparse", "[", "BoundListSparseR", "]"}]], "Input",
 CellChangeTimes->{
  3.7054637905309944`*^9, {3.7058966893990135`*^9, 3.705896690381954*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.008333333333333333], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw9lAk4lfkex89N5YpQmqaJcjqlRVokSrYvh+xyjn07jrM5hylTtkictGls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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.008333333333333333], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw11gs0lOseBvDJ6aboqqJsjW6nFJXbli2eCqUkNHKNGQYzQ4VdSKXJrqij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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.008333333333333333], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw11ntYTekeB/AtjtKo4QxRGjaKhCZKN+EblSjd79fVbt9DxnUmxc6JQ4xL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         "]]}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, AxesOrigin -> {0, 0}, 
     PlotRange -> {{0, 221.}, {-1.4995827273174775`, 2.9766018732716857`}}, 
     PlotRangeClipping -> True, ImagePadding -> All, DisplayFunction -> 
     Identity, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0, 221.}, {-1.4995827273174775`, 2.9766018732716857`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"\"Q\"", "\"DQ\"", "\"DDQ\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.15], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.15], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.15], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.15], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.15], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.15], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.70546379110553*^9, {3.705896687332026*^9, 3.705896691101638*^9}, 
   3.707212892295499*^9, 3.7078578561510763`*^9, 3.707857917416916*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Double", " ", "check", " ", "of", " ", "algebra", " ", "used", " ", "in", 
   " ", "Sparse", " ", "proof"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7078577837405577`*^9, 3.7078577988120327`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"s_", ",", "t_"}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"s", "^", "2"}]}], ")"}], " ", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"s", "+", "t"}], ")"}], "^", "2"}], "/", "2"}], "]"}], "/", 
    RowBox[{"(", " ", 
     RowBox[{"t", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        RowBox[{"t", "^", "2"}], "+", 
        RowBox[{
         RowBox[{"s", "^", "2"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"s", "+", "t"}], ")"}], "^", "2"}]}]}], ")"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.707212977948742*^9, 3.707213015796112*^9}, {
  3.707215251944702*^9, 3.7072152528045263`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Df", "[", 
   RowBox[{"s_", ",", "t_"}], "]"}], "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"s", ",", "t"}], "]"}], ",", "s"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7072144935493193`*^9, 3.707214504268615*^9}, 
   3.7072150698718386`*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"s", "+", "t"}], ")"}], "2"]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["s", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["s", "4"]}], "+", 
         SuperscriptBox["s", "6"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["s", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["s", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["s", "6"]}]}], ")"}], " ", "t"}], "+", 
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["s", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["s", "4"]}]}], ")"}], " ", 
       SuperscriptBox["t", "2"]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["s", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["t", "3"]}]}], ")"}]}], 
   RowBox[{"t", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["s", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "s"}], ")"}], " ", "t"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"t", "+", 
          RowBox[{"s", " ", 
           RowBox[{"(", 
            RowBox[{"s", "+", "t"}], ")"}]}]}], ")"}]}]}], ")"}], "2"]}]]}]],
  "Output",
 CellChangeTimes->{3.707215070236167*^9, 3.7072152552278585`*^9, 
  3.707857856702607*^9, 3.707857917885367*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Df", "[", 
      RowBox[{"s", ",", "t"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "t"}], "\[LessEqual]", "s", "\[LessEqual]", "0"}], "&&", 
      RowBox[{"0.0775", "\[LessEqual]", "t", "\[LessEqual]", "0.165"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "t"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.70721452225389*^9, 3.707214573919512*^9}, {
  3.707214681004351*^9, 3.707214682340643*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.33500659074433636`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", "5.916424637474516`*^-18"}], ",", 
     RowBox[{"t", "\[Rule]", "0.07750000000000001`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.707214524216772*^9, 3.7072145757883043`*^9, 
  3.7072152661413145`*^9, 3.7078578569848757`*^9, 3.7078579182377048`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Df", "[", 
      RowBox[{"s", ",", "t"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "t"}], "\[LessEqual]", "s", "\[LessEqual]", "0"}], "&&", 
      RowBox[{"0.0775", "\[LessEqual]", "t", "\[LessEqual]", "0.165"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "t"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.707213084578148*^9, 3.707213095007165*^9}, {
  3.7072146848060193`*^9, 3.7072146868419566`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6727720772159643`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", 
      RowBox[{"-", "0.16499998589148027`"}]}], ",", 
     RowBox[{"t", "\[Rule]", "0.1649999834407237`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.707214688583645*^9, 3.7072152687548485`*^9, 
  3.7078578577205825`*^9, 3.7078579190314665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Df", "[", 
   RowBox[{
    RowBox[{"Interval", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".165"}], ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Interval", "[", 
     RowBox[{"{", 
      RowBox[{"0.0775", ",", "0.165"}], "}"}], "]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.707214949355073*^9, 3.7072150173353834`*^9}, {
  3.7072152923845177`*^9, 3.707215292892005*^9}}],

Cell[BoxData["0.14098746811010113`"], "Output",
 CellChangeTimes->{3.7072150178488708`*^9, 3.707215074860627*^9, 
  3.7072152931482534`*^9, 3.7078578577386007`*^9, 3.707857919043477*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "s"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"s", "^", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"s", "+", "t"}], ")"}]}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"t", "^", "2"}], "+", 
       RowBox[{
        RowBox[{"s", "^", "2"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s", "+", "t"}], ")"}], "^", "2"}]}]}], ")"}]}], "-", 
    RowBox[{"2", "s", 
     RowBox[{"(", 
      RowBox[{"s", "+", "t"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "s"}], "+", "t"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"s", "^", "2"}]}], ")"}]}]}], "\[Equal]", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["s", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["s", "4"]}], "+", 
         SuperscriptBox["s", "6"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["s", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["s", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["s", "6"]}]}], ")"}], " ", "t"}], "+", 
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["s", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["s", "4"]}]}], ")"}], " ", 
       SuperscriptBox["t", "2"]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["s", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["t", "3"]}]}], ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7072158371106763`*^9, 3.707215888078622*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7072158890145206`*^9, 3.707857857780657*^9, 
  3.707857919084516*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"gammaHighR", "^", "3"}], "-", 
  RowBox[{"gammaLowR", 
   RowBox[{"(", 
    RowBox[{"3", "-", 
     RowBox[{"12", "*", 
      RowBox[{"gammaHighR", "^", "2"}]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.707216103020052*^9, 3.707216119074493*^9}}],

Cell[BoxData[
 RowBox[{"-", "0.20268862499999996`"}]], "Output",
 CellChangeTimes->{3.7072161206289625`*^9, 3.7078578577926702`*^9, 
  3.7078579191015363`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"betaR", "*", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"gammaHighR", "^", "2"}], "/", "2"}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{"gammaLowR", "*", 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"gammaLowR", "^", "2"}]}], ")"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.7072159803782907`*^9, 3.7072160235016813`*^9}}],

Cell[BoxData["1.140548403122083`"], "Output",
 CellChangeTimes->{3.707216024072228*^9, 3.7078578578036675`*^9, 
  3.70785791911855*^9}]
}, Open  ]]
},
WindowSize->{1920, 1037},
WindowMargins->{{1912, Automatic}, {Automatic, -8}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 245, 5, 50, "Input"],
Cell[806, 27, 249, 4, 50, "Input"],
Cell[1058, 33, 172, 3, 30, "Input"],
Cell[1233, 38, 1137, 24, 145, "Input"],
Cell[2373, 64, 298, 6, 30, "Input"],
Cell[CellGroupData[{
Cell[2696, 74, 752, 15, 30, "Input"],
Cell[3451, 91, 574, 11, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4062, 107, 627, 13, 30, "Input"],
Cell[4692, 122, 532, 10, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5261, 137, 411, 11, 30, "Input"],
Cell[5675, 150, 232, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5944, 158, 513, 12, 30, "Input"],
Cell[6460, 172, 259, 3, 30, "Output"]
}, Open  ]],
Cell[6734, 178, 956, 18, 50, "Input"],
Cell[7693, 198, 212, 5, 30, "Input"],
Cell[7908, 205, 681, 19, 50, "Input"],
Cell[CellGroupData[{
Cell[8614, 228, 202, 3, 30, "Input"],
Cell[8819, 233, 195, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9051, 241, 206, 3, 30, "Input"],
Cell[9260, 246, 165, 2, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9462, 253, 206, 3, 30, "Input"],
Cell[9671, 258, 22330, 434, 237, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32038, 697, 182, 3, 30, "Input"],
Cell[32223, 702, 24439, 468, 236, "Output"]
}, Open  ]],
Cell[56677, 1173, 240, 5, 30, "Input"],
Cell[56920, 1180, 788, 26, 30, "Input"],
Cell[CellGroupData[{
Cell[57733, 1210, 351, 10, 30, "Input"],
Cell[58087, 1222, 1987, 64, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60111, 1291, 538, 15, 30, "Input"],
Cell[60652, 1308, 390, 9, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61079, 1322, 543, 15, 30, "Input"],
Cell[61625, 1339, 383, 10, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62045, 1354, 443, 12, 30, "Input"],
Cell[62491, 1368, 186, 2, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62714, 1375, 2080, 68, 35, "Input"],
Cell[64797, 1445, 122, 2, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64956, 1452, 285, 8, 30, "Input"],
Cell[65244, 1462, 159, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65440, 1470, 383, 11, 30, "Input"],
Cell[65826, 1483, 135, 2, 30, "Output"]
}, Open  ]]
}
]
*)

