function [spikeLocs,spikeVals,sparseLocs,sparseVals,dualVar] = tvMinSparse(K, sampLocs, sampVals, spikeMesh, lambda)
%Recovers the location and weights on the spikes given sample data and a
%spike mesh using discrete total variation (i.e., L1) minimization.
%K : Kernel function
%sampLocs: shape = [1,n_samps], vector of sample locations
%sampVals: shape = [1,n_samps], vector of sample values
%spikeMesh: fine grid of locations on which spikes may lie
    sampVals = sampVals';
    D = makeDict(spikeMesh,sampLocs,K);
    cvx_begin quiet
    cvx_precision high
    variable x_esti(length(spikeMesh),1);
    variable z_esti(length(sampLocs),1);
    dual variable dual_esti;
    minimize(norm(x_esti,1) + lambda*norm(z_esti,1));
    subject to
        dual_esti: D*x_esti + z_esti == sampVals
    cvx_end
    spikeLocs = spikeMesh(abs(x_esti) > 1e-5);
    spikeVals = x_esti(abs(x_esti) > 1e-5)';
    sparseLocs = sampLocs(abs(z_esti) > 1e-5);
    sparseVals = z_esti(abs(z_esti) > 1e-5)';
    dualVar = dual_esti;
end