if(n_plot_frames>=current_frame) then let n_plot_frames:=current_frame-1;
   # Make sure we do not plot more then needed

print "Writing VRML animation to: ", plot_file, "with ", n_plot_frames, " frames!";

shell (sprintf("cp VRML/Protos%dD.wrl %s",d,plot_file));
print "# Model generated by AMPL for problem ", problem_name >> (plot_file);

if d=2 then {
   print "DiskPacking {" > (plot_file);
}
else
{
   print "SpherePacking {" > (plot_file);
}   
print "box_size_ 0 0 0" > (plot_file);
print "color_ 1 0 0" > (plot_file);
if n_ids=1 then
{
	if d=2 then 
	   {print "ResizingDisks_ Group { children [" > (plot_file);}
	else
	  {print "ResizingSpheres_ Group { children [" > (plot_file);}
}
else
{
	if d=2 then 
	  {print "MovingDisks_ Group { children [" > (plot_file);}
	else
	  {print "MovingSpheres_ Group { children [" > (plot_file);}
}   

if d=2 then {
	for {x in -n_replications..n_replications} {
	for {y in -n_replications..n_replications} {	   
	   let {frame in PLOT_FRAMES, k in DIMS} image_displacement[frame,k]:=
	      x*L_frames[frame,k,1]+y*L_frames[frame,k,2];

		for {i in 1..n} {
		   print "MovingDisk {" > (plot_file);     
		   if (x!=0) or (y!=0) then # An image disk 
		   {
		     if not active_nodes[i] then {print "color_ 0 1 1" > (plot_file)}
		        else {print "color_ 0 1 0" > (plot_file)};	   
		   }
		   else 
		   {
		     if not active_nodes[i] then print "color_ 0 0 1" > (plot_file);
		   }
		   if n_ids!=1 then
		      print "radius_ ", D[ID[i]]/2 > (plot_file);
		   print "shots_ [", 0.0, {frame in PLOT_FRAMES} frame/n_frames, "]" > (plot_file);
		   print "positions_ [", {k in DIMS} 
		     r[i,k]+x*L[k,1]+y*L[k,2], " , " > (plot_file);
		   print {frame in PLOT_FRAMES}: {k in DIMS} 
		      r_frames[frame,i,k]+image_displacement[frame,k], "," > (plot_file);
		   print "] }" > (plot_file);   
		}

	}
	}
}
else
{
	for {x in -n_replications..n_replications} {
	for {y in -n_replications..n_replications} {
	for {z in -n_replications..n_replications} {
	   let {frame in PLOT_FRAMES, k in DIMS} image_displacement[frame,k]:=
	      x*L_frames[frame,k,1]+y*L_frames[frame,k,2]+z*L_frames[frame,k,3];

		for {i in 1..n} {
		   print "MovingSphere {" > (plot_file);		     
		   if (x!=0) or (y!=0) or (z!=0) then # An image disk 
		   {
		     if not active_nodes[i] then {print "color_ 0 1 1" > (plot_file)}
		        else {print "color_ 0 1 0" > (plot_file)};	   
		   }
		   else 
		   {
		     if not active_nodes[i] then print "color_ 0 0 1" > (plot_file);
		   }  
		   if n_ids!=1 then
		      print "radius_ ", D[ID[i]]/2 > (plot_file);
		   print "shots_ [", 0.0, {frame in PLOT_FRAMES} frame/n_frames, "]" > (plot_file);
		   print "positions_ [", {k in DIMS} 
		     r[i,k]+x*L[k,1]+y*L[k,2]+z*L[k,3], " , " > (plot_file);
		   print {frame in PLOT_FRAMES}: {k in DIMS} 
		      r_frames[frame,i,k]+image_displacement[frame,k], "," > (plot_file);
		   print "] }" > (plot_file);   
		}
	
	}
	}
	}
}
print "] } # End of Spheres/Disks" > (plot_file);

if n_ids=1 then
{
	print "RadiusInterpolator_ RadiusInterpolator {" > (plot_file);
	if d=2 then print "is2D_ TRUE" > (plot_file);
	print "shots_ [", 0.0, {frame in PLOT_FRAMES} frame/n_frames, "]" > (plot_file);
	print "radii_ [", D[1]/2, {frame in PLOT_FRAMES} D_frames[frame,1]/2, "] }" > (plot_file);
}

print "} # End of AMPL packing" > (plot_file);

# EOF

