# Aleksandar Donev, December 2002
# Models for jamming in hard-sphere packings
# Updating the coordinates of the packing:

# Update the real sphere positions
let {i in NODES, k in DIMS} r_perturbed[i,k]:=r_perturbed[i,k]+dr_scaling*dr[i,k];
# Update the virtual-sphere positions   
let {k in DIMS, a in VIRTUAL_ARCS} r__perturbed[a,k]:=r__perturbed[a,k]+
    sum {i in DIMS} dr_scaling*strain[strain_indices[k,i]]*r__perturbed[a,i];
# And the sphere sizes
let {id in IDs} D_perturbed[id]:=D_perturbed[id]+dr_scaling*dD[id];
# And finally the lattice:    
let {i in DIMS, j in DIMS} L_perturbed[i,j]:=L_perturbed[i,j]+
   (sum {k in DIMS} dr_scaling*strain[strain_indices[i,k]]*L_perturbed[k,j]);    

# Update all the other dependent parameters:   
let {a in ARCS, k in DIMS} l_[a,k]:=
   if (a in REAL_ARCS) then 
      r_perturbed[H[a],k]-r_perturbed[T[a],k]
   else
      r_perturbed[H[a],k]-r_perturbed[T[a],k]+r__perturbed[a,k]
   ;

let {a in ARCS} l[a]:=sqrt( sum {k in DIMS} (l_[a,k]^2) );

let {a in ARCS} l_strut[a]:=(D_perturbed[ID[H[a]]]+D_perturbed[ID[T[a]]])/2;

let {a in ARCS, k in DIMS} u[a,k]:=l_[a,k]/l[a];

let l_min:=min {a in ARCS} l[a];
let l_max:=max {a in ARCS} l[a]; 

let {a in ARCS} active_arcs[a] := if l[a]<=l_strut[a]*(1+delta) then 1 else 0; 
   
# Save this for plotting purposes:
print "Updating frame #", current_frame;
let {i in NODES, k in DIMS} r_frames[current_frame,i,k]:=r_perturbed[i,k];
let {i in DIMS, j in DIMS} L_frames[current_frame,i,j]:=L_perturbed[i,j];
let {id in IDs} D_frames[current_frame,id]:=D_perturbed[id];      
let current_frame:=current_frame+1;

# EOF
