# Aleksandar Donev, December 2002
# Models for jamming in hard-sphere packings
# Scaling dr to the first collision:

let {a in ARCS} collision_time[a]:=
	if (active_nodes[H[a]] and active_nodes[T[a]]) then
	   if (dl[a]+l_strut[a]/l[a]*dl_strut[a])>0 # These will collide!
	   and (collision_sqrt[a]>0) then
	      l[a]/((sum{k in DIMS}dl_[a,k]^2)-dl_strut[a]^2)*
	      ((dl[a]+l_strut[a]/l[a]*dl_strut[a])-sqrt(collision_sqrt[a]))
	   else
	      Infinity
	else
	   Infinity ;
	   
let dr_scaling:=min{a in ARCS: collision_time[a]>0} collision_time[a];
if dr_scaling=Infinity then 
{
   print "UNBOUNDED UNJAMMING MOTION! Scaling set to 10...";
   let dr_scaling:=10; # To avoid Infinities
}   
if dr_scaling<=1E-2 then 
{
   print "SUSPICIOUSLY SMALL SCALING! Setting to 1 by default...";
   let dr_scaling:=1;
}   
print "Scaling for unjamming motion is: ", dr_scaling;

let {a in ARCS: collision_time[a]=dr_scaling} critical_arc:=a;
# print "At collision: D=",l_strut[critical_arc]+dr_scaling*dl_strut[critical_arc],"=",
#   sqrt(sum{k in DIMS}(l_[critical_arc,k]-dr_scaling*dl_[critical_arc,k])^2);

# EOF

