#!/bin/bash
# Usage:
# $1=Name of problem
# $2=Name of AMPL run script (D, Jam, etc.)
# $3=Near-neighbour tolerance (delta)
# $4=Displacement tolerance (dr_max)
# $5=Collective (1) or strict (0) (no_strain)

problem_name=$1
optimization=$2
delta=$3
dr_max=$4
no_strain=$5
use_kestrel=0 # Avoid kestrel if possible

if [ -e Data/${problem_name}.extra.dat ]
then
   read_extra=1;
else
   read_extra=0;   
fi

if [ ${no_strain} -eq 0 ]
then
   log_file=Output/${problem_name}.${optimization}.collective.output
else
   log_file=Output/${problem_name}.${optimization}.strict.output
fi   

sed_script=$1.temp.sed
run_file=$1.temp.run

# Making the lattice:
rm -f ${sed_script}
echo "s/_problem_name/${problem_name}/" >> ${sed_script}
echo "s/_delta/${delta}/" >> ${sed_script}
echo "s/_displacement_tolerance/${dr_max}/" >> ${sed_script}
echo "s/_no_strain/${no_strain}/" >> ${sed_script}
echo "s/_read_extra/${read_extra}/" >> ${sed_script}
echo "s/_use_kestrel/${use_kestrel}/" >> ${sed_script}
echo "s/_random_seed/$RANDOM/" >> ${sed_script}

rm -f ${run_file}
cat DR.run $2.run | sed -f ${sed_script} > ${run_file}

ampl ${run_file} | tee ${log_file}

rm -f ${sed_script}
rm -f ${run_file}

# EOF
