# Aleksandar Donev, December 2002
# Models for jamming in hard-sphere packings
# Part II: Displacement-based formulation:

var dr {i in NODES, k in DIMS} >=-n*l_eq_min, <=n*l_eq_min default 0;
   # The displacements of the nodes
# We normalize it dr to no translation:
param dr_average{DIMS};

param average_displacement;
   # The average nodal displacement
param maximal_displacement;  
   # The largest nodal displacement 
param displacement_tolerance >0 default 1;
   # What motion is unjamming/too large?
   
param b {i in NODES, k in DIMS} default Uniform(-1,1);
   # The random nodal loads--direction of probing

# For strict jamming we also have the strain:
param strain_indices {i in DIMS, j in DIMS} := 
   if (i<=j) then (i-1)*(d+1)-i*(i-1)/2+j-i+1 
   else (j-1)*(d+1)-j*(j-1)/2+i-j+1 ;
   # This numbers strain components by rows!

var strain {h in STRAIN_DIMS} <=n, >=-n, default 0; # As a vector!
   # To get the matrix [i,j] use strain[strain_indices[i,j]]

# Collective or strict jamming?:
param no_strain binary default 1;
   # Should the lattice strain be included in the formulation?

subject to strain_trace:
   sum {k in DIMS} strain[strain_indices[k,k]]<=0;

# The linearized length change (dilation):
var dl_ {a in ARCS, k in DIMS} = 
   if (a in REAL_ARCS) then
      dr[T[a],k]-dr[H[a],k]
   else
      (dr[T[a],k]-dr[H[a],k])-(sum{h in DIMS} strain[strain_indices[k,h]]*r__perturbed[a,h])
   ;
var dl {a in ARCS} = sum {k in DIMS} dl_[a,k]*u[a,k];
   # Automatically substituted by AMPL!

param collision_time{ARCS} default 1; # Maybe add >=0 here (causes problems)
param dr_scaling>=0 default 1;
   # We scale linear motions up to the first real collision

param D_relaxation{IDs} >0, <=1 default 1;
param D{id in IDs} default l_min;
param overlap{IDs, IDs};

param D_perturbed{id in IDs} default D_relaxation[id]*D[id];

var dD{IDs} >=0, <=n*l_eq_min default 0; # The change in diameter

param l_strut{a in ARCS} default (D_perturbed[ID[H[a]]]+D_perturbed[ID[T[a]]])/2;
var dl_strut{a in ARCS}=(dD[ID[H[a]]]+dD[ID[T[a]]])/2;

param delta >0 default max {a in ARCS} (l[a]/l_strut[a]-1); # Gap tolerance
   # Cutoff length for including constraints (relative)
   # By default we include *all* constraints given in the data
param active_arcs {a in ARCS} binary default 
   if l[a]<=l_strut[a]*(1+delta) then 1 else 0; 
param m_active>=0 integer default card({a in ARCS: active_arcs[a]});

param active_nodes {i in NODES} binary default 1;
param n_active>=0 integer default card({i in NODES: active_nodes[i]});

param dilution >=0, <1 default 0;
   # Possible random removal of nodes?

var collision_sqrt {a in ARCS}=
   (dl[a]+l_strut[a]/l[a]*dl_strut[a])^2-
   (1-(l_strut[a]/l[a])^2)*((sum{k in DIMS}dl_[a,k]^2)-dl_strut[a]^2);

param test_D_jamming binary default 1;
   
minimize Dilations:
   sum {k in DIMS, a in ARCS: active_arcs[a]} dl[a];

minimize Work:
   sum {i in NODES, k in DIMS} b[i,k]*dr[i,k];

maximize Diameter: sum{id in IDs} dD[id]; 
   # One could add randomness here?

param steepness>0 default 0.01;

# A cost-function that strongly rewards small gaps:   
maximize Diameter_TANH:
   sum {a in ARCS: active_arcs[a]} -tanh(((l[a]-l_strut[a])-dl[a])/l_strut[a]/steepness);
      
# f (forces) are the dual variables of the constraints:
subject to f {a in ARCS: active_arcs[a]}:
# Nonlinear correction:
#   - (sum {k in DIMS} (dr[T[a],k]-dr[H[a],k]
#      -(sum{h in DIMS} strain[strain_indices[k,h]]*r__perturbed[a,h]))^2/2/l[a] +
# Linear part:
    dl[a] <= 
# RHS:      
      # 0 # Homogeneous part
      l[a]-l_strut[a]-dl_strut[a] # First-order piece
      # (l[a]-l_strut[a]-dl_strut[a])*(1+(l_strut[a]+dl_strut[a])/l[a])/2 # True non-linear value
      ;

# Impenetrability in non-polished form (for testing purposes):
# subject to f {a in ARCS}:
#   if(a in REAL_ARCS) then
#      sum {k in DIMS} ((r_perturbed[H[a],k]-r_perturbed[T[a],k]+dr[H[a],k]-dr[T[a],k])^2)
#   else
#      sum {k in DIMS} ((r_perturbed[H[a],k]-r_perturbed[T[a],k]+r_[a,k]+dr[H[a],k]-dr[T[a],k])^2)
#   >= (l_strut[a]+dl_strut[a])^2 ;


# I use VRML to plot unjamming motions:
param n_frames>=0 integer default 1; 
   # Additional frames (+ initial configuration) to plot
set FRAMES:={1..n_frames} ordered; # The frames in the animations
param current_frame>=0 integer default 1;
param n_plot_frames>=0 integer default n_frames;
set PLOT_FRAMES in FRAMES default {1..n_plot_frames};

param r_frames{FRAMES, NODES, DIMS};
param L_frames{FRAMES, DIMS, DIMS};
param D_frames{FRAMES, IDs}; # The common diameter

param n_replications>=0 integer default 1;
param image_displacement{FRAMES,DIMS}; # Used for replication of the generating packing         

# The first collision:
param critical_arc in ARCS;

# Parameters for jamming test:
# How many random loads to try (+b and -b are both tested!)
param n_unjamming_loads>0, integer default 1;
# Should I try iteratively to find jammed subpacking?  
param test_subpacking binary default 0;
param n_subpacking_attempts >=0, integer default if (test_subpacking>0) then 2 else 1;
param n_jamming_LPs >=0, integer default 1;
# Temporaries:    
param n_displaced>=0, integer;
param n_rattling>=0, integer;
param unjammed binary default 0; # Indicator for jamming

# Parameters for compression:
param n_compressions>=0 default 10;

# EOF
