program Indentation

   integer :: d, n_cells(3) ! dimensionality and grid size
   real :: acceleration
   
   read(*,*) d
   read(*,*) n_cells(1:d)
   read(*,*) acceleration
   
   if(d==2) then
      n_cells(3)=1
   end if   
   
   call write_grid(n_cells)
   
contains

   subroutine write_grid(n_cells)
      integer, intent(in) :: n_cells(3)
      
      logical, dimension(n_cells(1),n_cells(2),n_cells(3)) :: hw, nhw
      real, dimension(n_cells(1),n_cells(2),n_cells(3)) :: accelerations      
      integer :: i, j, k, dim, nx, ny
      
      hw=.false.
      nhw=.false.
      accelerations=0.0
   
      ! Create cell masks for a channel with an indentation that is one third of the channel in x/y directions
      nx=n_cells(1)/3
      ny=n_cells(2)/3      
      
      hw(:,n_cells(2),:)=.true. ! Top wall
      nhw(:,n_cells(2)-1,:)=.true.
      
      hw(:,1,:)=.true. ! Bottom wall
      nhw(nx+1:n_cells(1)-nx,2,:)=.true.

      hw(1:nx,1:ny,:)=.true. ! Left bump
      nhw(1:nx,ny+1,:)=.true.
      nhw(nx+1,3:ny+1,:)=.true.
      
      hw(n_cells(1)-nx+1:,1:ny,:)=.true. ! Right bump
      nhw(n_cells(1)-nx:,ny+1,:)=.true.
      nhw(n_cells(1)-nx,3:ny+1,:)=.true.
      
      ! Accelerations in the non-indentation portion only:
      accelerations(:,ny+1:,:)=acceleration  
      
      write(*,*) n_cells(1:d), 2
      do k=1, n_cells(3)
      do j=1, n_cells(2)
      do i=1, n_cells(1)
         write(*,*) hw(i,j,k), nhw(i,j,k), accelerations(i,j,k), (0.0,dim=2,d), (0.0,dim=1,d)
      end do
      end do
      end do   
  
   end subroutine   

end program
