% Allows to select a subimage and save the corresponding initial points
% using TILT
%
% Author: Carlos Fernandez-Granda 
% Email: cfgranda@stanford.edu

addpath('./TILT_v1_04')
addpath('./code')
clear all
close all

[img_name, img_path]=uigetfile('*.*');
img=imread(fullfile(img_path, img_name));
    
figure(1);
imshow(img,[]);
hold on
initial_points=zeros(2, 2);
for i=1:2
	initial_points(:, i)=ginput(1)';
    plot(initial_points(1, i), initial_points(2, i), 'rx');
    hold on;
end
initial_points=floor(initial_points);
focus_size=[initial_points(2, 2)-initial_points(2, 1)+1 initial_points(1, 2)-initial_points(1, 1)+1];
img_center=floor(mean(initial_points, 2));

tic
[Dotau, A, E,f,tfm_matrix, focus_size, error_sign, UData, VData, XData, YData, A_scale]=...
TILT(img, 'HOMOGRAPHY', initial_points, 'SAVE_PATH', [], 'DISPLAY_INTER', 1);
toc

save initial_points_32_def initial_points