% Directional total variation solver with l2 norm regularizaiton, uses TFOCS (http://tfocs.stanford.edu/)
%
% Author: Carlos Fernandez-Granda 
% Email: cfgranda@stanford.edu

function varargout = solver_DTV_L2( A, b,lambda,  mu, x0, z0,n1,n2, opts, varargin )

W1= linop_TV_x( [n1,n2] );
W2= linop_TV_y( [n1,n2] );
nonneg = false;
if isfield(opts,'nonneg')
    nonneg  = opts.nonneg;
    opts = rmfield(opts,'nonneg');
end
if isfield(opts,'nonNeg')
    nonneg  = opts.nonNeg;
    opts = rmfield(opts,'nonNeg');
end
% Need to estimate the norms of A*A' and W*W' in order to be most efficient
if isfield( opts, 'noscale' ) && opts.noscale,
    normA2 = 1; normW12 = 1; normW22 = 1;
else
    normA2 = []; normW12 = []; normW22 = [];
    if isfield( opts, 'normA2'  )
        normA2 = opts.normA2;
        opts = rmfield( opts, 'normA2' );
    end
    if isfield( opts, 'normW12' )
        normW12 = opts.normW12;
        opts = rmfield( opts, 'normW12' );
    end
    if isfield( opts, 'normW22' )
        normW22 = opts.normW22;
        opts = rmfield( opts, 'normW22' );
    end
end
if isempty( normA2 ),
    normA2 = linop_normest( A ).^2;
end
if isempty( normW12 ),
    normW12 = linop_normest( W1 ).^2;
end
if isempty( normW22 ),
    normW22 = linop_normest( W2 ).^2;
end

if nonneg       
    % -- case: x >= 0 constraints
    prox    = proj_Rplus;
else
    % -- case: no x >= 0 constraint
    prox    = [];
end

proxScale1 = sqrt( normW12 / normA2 );
proxScale2 = sqrt( normW22 / normA2 );
prox2       = { smooth_quad, ...
               proj_linfl2_T_mod( [proxScale1 * lambda,n1,n2,n1,n2] ),...
               proj_linfl2_mod( [proxScale2 * lambda,n1,n2,n1,n2] ) };
W1         = linop_compose( W1, 1 / proxScale1 );
W2         = linop_compose( W2, 1 / proxScale2 );
[varargout{1:max(nargout,1)}] = ...
    tfocs_SCD( prox, { A, -b; W1, 0; W2, 0 }, prox2, mu, x0, z0, opts, varargin{:} );


% TFOCS v1.1 by Stephen Becker, Emmanuel Candes, and Michael Grant.
% Copyright 2012 California Institute of Technology and CVX Research.
% See the file TFOCS/license.{txt,pdf} for full license information.
