(* ::Package:: *)

<< BumpWave6`


numPerGammaG = 500;
numPerDeltaG = 700;
numDeltaG = 5;
kappaG = .05;
lambdaG = 2;
factorG = 10;
epsG = 10^(-10)/kappaG;
tailG = 10;
gammaListG = Array[# &,200,{kappaG,1}];
DeltaListG = Array[# &,200,{2.0,8.0}];


DeltaMaxG = Max[DeltaListG];
gammaMaxG = Max[gammaListG];
DeltaWidthG = DeltaMaxG/numPerDeltaG;
gammaWidthG = gammaMaxG/numPerGammaG;
gListG = Ceiling[gammaListG/gammaWidthG-EPS];		
DListG = Floor[DeltaListG/DeltaWidthG+EPS];


(*Can take many hours (1+ days) on a 3ghz 6-core machine.*)


KG[t_] = Exp[-t^2/2];


Print[AbsoluteTiming[funListGauss = makeFunctions[gammaWidthG,DeltaWidthG,numPerGammaG,numDeltaG+1,numPerDeltaG,kappaG,KG,epsG,tailG,factorG];]];


Print[AbsoluteTiming[{IDWValsG,ICValsG,trueGammaListG,trueDeltaListG} = makeIDWandICTables[funListGauss,gammaListG,gammaWidthG,DeltaListG,DeltaWidthG,numDeltaG,epsG];]];


datestr = DateString[DateList[],{"Month","Day","Year","Hour","Minute","Second","Millisecond"}];
filename = "Gauss"<>ToString[numPerGammaG]<>"-"<>ToString[numPerDeltaG]<>"-"<>ToString[kappaG]<>"-"<>datestr<>".mx";


Print[AbsoluteTiming[SuccessTableG = makeKernelSuccessTable[funListGauss,gammaListG,gammaWidthG,DeltaListG,DeltaWidthG,numDeltaG,epsG];]];


Print[AbsoluteTiming[T1TableG =makeT1Table[funListGauss,gammaListG,gammaWidthG,DeltaListG,DeltaWidthG,numDeltaG,epsG];]];


Print[AbsoluteTiming[C2PTableG= makeC2PTable[funListGauss,gammaListG,gammaWidthG,DeltaListG,DeltaWidthG,numDeltaG,epsG];]];


Print[AbsoluteTiming[SuccessTableSparseG = makeKernelSuccessTableSparse[funListGauss,gammaListG,gammaWidthG,DeltaListG,DeltaWidthG,numDeltaG,lambdaG,epsG,True];]];


DumpSave[filename,{IDWValsG,ICValsG,SuccessTableG,T1TableG,C2PTableG,SuccessTableSparseG,KG,funListGauss,
					numPerGammaG,numPerDeltaG,numDeltaG,kappaG,lambdaG,factorG,epsG,tailG,gammaListG,DeltaListG,gammaMaxG,DeltaMaxG,gammaWidthG,DeltaWidthG,gListG,DListG}];
