(* ::Package:: *)

<< BumpWave6`


numPerGammaR = 500;
numPerDeltaR = 700;
numDeltaR = 5;
kappaR = .05;
lambdaR = 2;
factorR = 10;
epsR = 10^(-10)/kappaR;
tailR = 10;
gammaListR = Array[# &,200,{kappaR,.7}];
DeltaListR = Array[# &,200,{2.0,8.0}];


DeltaMaxR = Max[DeltaListR];
gammaMaxR = Max[gammaListR];
DeltaWidthR = DeltaMaxR/numPerDeltaR;
gammaWidthR = gammaMaxR/numPerGammaR;
gListR = Ceiling[gammaListR/gammaWidthR-EPS];		
DListR = Floor[DeltaListR/DeltaWidthR+EPS];


(*Can take many hours (1+ days) on a 3ghz 6-core machine.*)


KG[t_] = Exp[-t^2/2];
KR[t_] = FullSimplify[-D[KG[t],{t,2}]];


Print[AbsoluteTiming[funListRicker = makeFunctions[gammaWidthR,DeltaWidthR,numPerGammaR,numDeltaR+1,numPerDeltaR,kappaR,KR,epsR,tailR,factorR];]];


Print[AbsoluteTiming[{IDWValsR,ICValsR,trueGammaListR,trueDeltaListR} = makeIDWandICTables[funListRicker,gammaListR,gammaWidthR,DeltaListR,DeltaWidthR,numDeltaR,epsR];]];


datestr = DateString[DateList[],{"Month","Day","Year","Hour","Minute","Second","Millisecond"}];
filename = "Ricker"<>ToString[numPerGammaR]<>"-"<>ToString[numPerDeltaR]<>"-"<>ToString[kappaR]<>"-"<>datestr<>".mx";


Print[AbsoluteTiming[SuccessTableR = makeKernelSuccessTable[funListRicker,gammaListR,gammaWidthR,DeltaListR,DeltaWidthR,numDeltaR,epsR];]];


Print[AbsoluteTiming[T1TableR =makeT1Table[funListRicker,gammaListR,gammaWidthR,DeltaListR,DeltaWidthR,numDeltaR,epsR];]];


Print[AbsoluteTiming[C2PTableR= makeC2PTable[funListRicker,gammaListR,gammaWidthR,DeltaListR,DeltaWidthR,numDeltaR,epsR];]];


Print[AbsoluteTiming[SuccessTableSparseR = makeKernelSuccessTableSparse[funListRicker,gammaListR,gammaWidthR,DeltaListR,DeltaWidthR,numDeltaR,lambdaR,epsR,False];]];


DumpSave[filename,{IDWValsR,ICValsR,SuccessTableR,T1TableR,C2PTableR,SuccessTableSparseR,KR,funListRicker,
					numPerGammaR,numPerDeltaR,numDeltaR,kappaR,lambdaR,factorR,epsR,tailR,gammaListR,DeltaListR,gammaMaxR,DeltaMaxR,gammaWidthR,DeltaWidthR,gListR,DListR}];
