function D = makeDict(spikeMesh,sampLocs,K)
%Produces a dictionary D of shape=[length(sampLocs),length(spikeMesh)] 
%with D(i,j) = K(sampLocs(j)-spikeMesh(i)).
%spikeMesh : shape=[1,n_meshPoints], locations of potential spikes
%sampLocs : shape=[1,n_samps], location of samples
%K : kernel
    diffs = repmat(sampLocs',1,length(spikeMesh))-repmat(spikeMesh,length(sampLocs),1);
    D = K(diffs);
end