function sampVals = sampleKernel(K, spikeLocs, spikeVals, sampLocs)
%Produces a [1,length(sampLocs)] vector of values giving the exact samples
%take from the convolution of K with the given spike train.
%K : kernel
%spikeLocs: shape=[1,n_spikes], vector of spike locations
%spikeVals: shape=[1,n_spikes], vector of spike weights
%sampLocs: shape=[1,n_samps], vector of sample locations
    sampVals = (makeDict(spikeLocs,sampLocs,K) * spikeVals')';    
end