
# Numerical Methods II, Courant Institute, NYU, spring 2018
# http://www.math.nyu.edu/faculty/goodman/teaching/NumericalMethodsII2018/index.html
#  written by Jonathan Goodman (instructor)
#  see class notes Part 1 for more discussion

# Use an ODE solver to make a movie of the dynamics of a 1D nonlinear lattice

# This computes the lattice point forces and returns f(x) = dx/dt

#  The model: force on x_k = F_k
#          F_k = [(x_{k+1}-x_k)] - [(x_k-x_{k-1)] + a*( [.]^3 - [.]^3)


import numpy as np

a = 200.               # coefficient of nonlinearity

def f(x):             # compute and return f(x)
    d  = x.size
    N  = d/2          # lattice point positions = half the dynamical variables ...
    rx = x[0:N]       #  ... the first half
    rv = x[N:2*N]     # lattice point velocities = second half
    
    fr = np.ndarray(d)    # f = dx/ddt, size d array to be returned
    F  = np.ndarray(N)    # the forces, one for each lattice point
    
    
#     Compute the forces

    for k in range(1,N-1):  #    the "interior" lattice points that don't wrap around

        dxl = x[k] - x[k-1]   # Delta x, on the left
        dxr = x[k+1]-x[k]     # Delta x, on the right
    
        F[k] = dxr - dxl + a*( dxr*dxr*dxr - dxl*dxl*dxl )
        
    dxl  = x[0] - x[N-1]   # lattice point k=0 wraps on the left to N-1
    dxr  = x[1]-x[0]       # but doesn't wrap on the right
    F[0] = dxr - dxl + a*( dxr*dxr*dxr - dxl*dxl*dxl )
    
    dxl = x[N-1] - x[N-2]   # lattice point k=N-1 doesn't wrap on the left
    dxr = x[0]-x[N-1]       # but wraps on the right
    F[N-1] = dxr - dxl + a*( dxr*dxr*dxr - dxl*dxl*dxl )


    fr[0:N]   = rv
    fr[N:2*N] = F
    
    return fr
