% simple energy balance model based on equation 3.13 and program 
% in Sec. 3.4 of "A Climate Modeling Primer", 1st Edition, 1987,
% by a. henderson-sellers and k. mcguffie.
%
% written by david holland, feb 2002

%--------------------------------------------------------------------------

% global variables

  global num_lat_zones lats lats_frac
  global insolation albedo temp
  
%--------------------------------------------------------------------------

% define geometry of earth as sequence of latitude bands

  geometry_setup;
  
%--------------------------------------------------------------------------

% (solar) insolation per latitude band 

  insolation_setup;
    
%--------------------------------------------------------------------------

% initial guess for latitudinal temperature distribution (cold earth)
   
  for j = 1:num_lat_zones
     temp(j) = -60.0;
  end
  
% average planetary temperature for a range of warming solar multipliers
  
  for k = 60:140
     solar_mult(k) = k/100.0;
     avg_temp(k) = solve_temp (solar_mult (k));                             
  end
 
  figure
  plot (solar_mult(60:140), avg_temp(60:140),'b');
  title('Average Temperature versus Solar Multiplier');
  xlabel('Solar Multiplier');
  ylabel('Average Temperature');
  axis([.60 1.60 -60. 60.]);
  hold on
  
%--------------------------------------------------------------------------

% average planetary temperature for a range of cooling solar multipliers

  for k = 140:-1:60
     solar_mult(k) = k/100.0;
     avg_temp(k) = solve_temp (solar_mult (k));                              
  end
 
  plot (solar_mult(60:140), avg_temp(60:140),'r');
  title('Average Temperature versus Solar Multiplier');
  xlabel('Solar Multiplier');
  ylabel('Average Temperature');
  axis([.60 1.40 -60. 60.]);

%--------------------------------------------------------------------------

% EOF