% determine insolation as fucntion of latitude band

  function f_result = insolation_setup 
  
%--------------------------------------------------------------------------

% global variables

  global num_lat_zones lats lats_frac
  global insolation albedo temp
  
%--------------------------------------------------------------------------

% adjustable parameters

  solar_constant = 1370;              % solar constant
  max_tilt = 23.5;                    % tilt of earth in degrees
  days_in_year = 365.0;               % averaging interval and period for insolation
  hours_in_day= 24.0;
  zonal_degrees = 360.0;
  
%--------------------------------------------------------------------------

%  daily rotation of earth reduces solar constant by distributing the sun
%  energy all along a zonal band

   total_solar = 0.0;
   
   for hour = 1:hours_in_day
       noon_angle = zonal_degrees * hour / hours_in_day;
       for longitude = 1:zonal_degrees
          sun_angle = longitude - noon_angle;
          total_solar = total_solar + solar_constant ...
                      * max (0.0, cos (pi/180.0*sun_angle));
      end
   end
   
   solar_constant = total_solar /(hours_in_day * zonal_degrees);

%--------------------------------------------------------------------------
  
% initialize insolation to zero
  
  insolation(1:num_lat_zones) = 0.0;
 
% accumulate normalized insolation through a year
  
  for day = 1:days_in_year
     tilt = max_tilt * cos (2.0*pi*day/days_in_year);
     for j = 1:num_lat_zones
        zenith = min (lats(j)+ tilt,90.0);
        insolation(j) = insolation (j) + cos (zenith*pi/180.);
     end
  end

% average unnormalized insolation over one year

  insolation = solar_constant * insolation / days_in_year;
  f_result = insolation; 
   
  avg_insolation = sum (lats_frac.*insolation);
% disp(['Average Insolation is ' num2str(avg_insolation) ' Watts/m^2']);
  
%--------------------------------------------------------------------------
    
  figure
  plot (lats,insolation)
  title('Insolation versus Latitude')
  xlabel('Latitude')
  ylabel('Insolation')
  axis([0. 90. 0. 500.]) 
  
%--------------------------------------------------------------------------  
  
% EOF