% purpose: post processing of stream function solution

% basic variables
qg_globals;

% get forcing data
load qg_forcing_data

[M,N] = size(X);
mx = M-3;
my = N-3;

% ghost points
ig = [1:M];
jg = [1:N];

% boundary points
ib = [2:M-1];
jb = [2:N-1];

% interior solution points
is = [3:M-2];
js = [3:N-2];

x = X(ib,1);
y = Y(1,jb)';

for ii = 1:nplot
  load (['qg'num2str(ii)])
  maxpsi(ii) = max(max(psi(ib,jb)));
  minpsi(ii) = min(min(psi(ib,jb)));
%  text(0.025,1.05,['d_I = 'num2str(di)],'fontsize', 12)
%  text(0.35,1.05, ['d_S = 'num2str(ds)],'fontsize', 12)
%  text(0.6525,1.05,['d_M = 'num2str(dm)],'fontsize', 12)
  tt(ii) = time;
  psipt(ii) = psi(5,21);
  psimid(:,ii) = psi(ib,18);
end

% eof