function qg_bc (stream_in);

% purpose: impose lateral boundary conditions

% basic variables
qg_globals;

% normal-flow condition: 
% stream as zero boundary conditions on boundary (must apply),
% not touching the ghost zone values

stream_in (   2,:   ) = zeros (1 ,my);   % western boundary
stream_in (mx-1,:   ) = zeros (1 ,my);   % eastern "
stream_in (:   ,   2) = zeros (mx, 1);   % southern "
stream_in (:   ,my-1) = zeros (mx, 1);   % northern "
  
% tangential-flow condition:
% (only relevant for munk boundary layers)
% no-slip : d(stream)/dn  = 0,  ghost points equal to first interior point.
% yes-slip: del^2(stream) = 0,  ghost points equal to negative of first interior point. 

stream_in (1 ,: ) = (-1)^slip_w * stream_in (   3,:   );   % western boundary
stream_in (mx,: ) = (-1)^slip_e * stream_in (mx-2,:   );   % eastern "
stream_in (: , 1) = (-1)^slip_s * stream_in (:   ,   3);   % southern " 
stream_in (: ,my) = (-1)^slip_n * stream_in (:   ,my-2);   % northern "

return

% eof

