function qg_coordinates;

% purpose: assign space and time coordinates

% basic variables
qg_globals;

% basin size 
lx = 1.0;
ly = 1.0;

% number of grid cells in x-direction and y-direction.
% code runs fastest in a square basin (ly = ly) and with mx a power or 2.
% grid includes a surounding ring of ghost cells 
% (used to implement no-slip boundary conditions)
mx = 32;
my = 32;

% grid cell size (accounting for ghost zone)
% (currently, msut have dx and dy as same)
dx = lx / (mx-3);
dy = ly / (my-3);

% indicies of ghost points
ig = [1:mx];
jg = [1:my];

% indicies of boundary points
ib = [2:mx-1];
jb = [2:my-1];

% indicies of (interior) solution points
is = [3:mx-2];
js = [3:my-2];

% independent coordinates, x and y
% (flip directions using transpose operator)
x = dx * [-1:1:mx-2]';
y = dy * [-1:1:my-2]';
[X,Y] = meshgrid (x,y);
X = X';
Y = Y';

% time information
% tmin is initial time
% dt is time step for integration
% tmax is final time
% mt is number of time steps
% run_no is run-sequence number
tmin = 0.0;
tmax = 100.0;
dt   = 0.10;
mt   = round ((tmax-tmin)/dt);
run_no = 0;

% indicies of time
it = [1:mt];

% dependent coordinate, t
t = tmin + dt * [1:mt];

% initial time
time_now = tmin;

% plotting info
% dt_plot is time interval for intermediate plotting and logging results
% to *.mat files named qg_run_no.mat, where 'no' is 1,2,3,...
% mt_plot : number of model time steps per plotting step
dt_plot = 10.0;
mt_plot = round(dt_plot/dt);

return

% eof