% purpose: driver routine for barotropic qg (quasi-geostrophic) basin model.
%
% note: normalized as in eqn (2.3.2) in pedlosky, 1996, ocean circulation theory:
% d(D^2(psi))/dt + di^2 J(psi,D^2(psi)) + dpsi/dx = we - ds D^2(psi) + dm^3 D^4(psi)
% where D represents del operator, and
% pedlosky's symbols are equivalenced here as: 
% epsilon = di^2, mu = ds, E = dm^3.
%
% running: set parameters, then from matlab prompt type "qg_driver".
% 
% written: karl helfrich, 2000; modified by david holland, 2003;
%
% key variables:  psi - streamfunction;
%                 chi - d psi / dt;
%                 zeta - relative vorticity;
%                 we - ekman pumping;
%                 f_rhs - forcing term of rhs of qg eqn

% clear previous workspace and figures etc.
warning off;
clear all;
close all;

% basic variables
qg_globals;

% initialize figures and handles
qg_initialize_figs;

% temporal and spatial domain
qg_coordinates;

% define qg parameters
qg_parameters;

% initialize stream function
qg_initialize_stream;

% ekman pumping field 
qg_ekman;

% save forcing data for possible restart runs
file_save = ['qg_runs/qg_run_' num2str(run_no) '_forcing.mat' ];
save (file_save);
  
% start time stepping
qg_time_step;

% eof