function qg_ekman ;

% purpose: assign surface ekamn pumping distribution

% basic variables
qg_globals;

% intialize arrays 
w_ekman = zeros (mx,my) ;

% abandon: no ekman pumping
if ekman_pumping == 0
   return
end

% alternative: classical westerlies and tradewinds pattern
w_ekman (is,js) = -sin (pi/ly*Y (is,js));

% alternative: circular pattern
%w_ekman (is,js) = -sin (pi/lx*X (is,js)).* sin (pi/ly*Y (is,js));
 
% alternative: uniform upwelling (positive) or downwelling (negative)
%w_ekman (is,js) = -ones (size (X (is,js)));

% alternative: circular patch of downwelling centered at (x0, y0)
%x0 = 0.6;, y0 = 0.5;, r0 = 0.25;
%w_ekman = zeros(size(X));
%r = sqrt((X-x0).^2 + (Y-y0).^2);
%[I,J] = find(r <= r0);
%JJ = sub2ind (size(X),I,J);
%we(JJ) = -ones(length(JJ),1);

% plot ekman pumping
   qg_plot_ekman;
   
return

% eof