function qg_f_rhs (stream_in);

% purpose: calculate rhs of elliptic problem for chi: del^2 (chi) = f_rhs,
% where f_rhs = w_ekman - d stream/dx - ds del^2(stream) - di^2 J(stream,del^2(stream)) + dm^3 del^4(stream)

% basic variables
qg_globals;

% initialize some arrays
d2stream = zeros (mx,my);
d4stream = zeros (mx,my);
f_rhs = zeros (mx,my);

% calculate del^2 stream
% (order of arguments for x and y grid spacing are reversed 
%  for consistency with matlab sense of matrix orientation)
% (prefactor of 4 is also for consistency with matlab defn of laplacian)
d2stream (ig,jg) = 4 * del2 (stream_in (ig,jg), dy, dx);

% relative vorticity is del^2 stream
zeta_rel (ig,jg) = d2stream;

% calculate del^4 stream for lateral friction term (if munk friction used)
if dm ~= 0
   d4stream (ig,jg) = 4*del2 (d2stream (ig,jg), dy, dx);
end

% calculate velocity 
qg_velocity (stream_in (ig,jg));

% calculate jacobian
qg_jacobian (stream_in (ig,jg), zeta_rel (ig,jg), u (ig,jg), v (ig,jg));

% calculate right-hand-side forcing, in interior of domain, 
% (multiply by dx^2 (assumes dy = dx) in preparation for elliptic solver).
f_rhs (is,js) = dx^2 ... 
              *(w_ekman (is,js) ...
              - beta_effect * v (is,js) ...
              - ds   * d2stream    (is,js) ...
              - di^2 * jacobian (is,js) ...
              + dm^3 * d4stream    (is,js));

return

% eof