function qg_initialize_stream

% purpose: initialize streamfunction and related quantities

% basic variables
qg_globals;

% run_no is number of the qg_run_no.mat file which holds the restart data.
if tmin == 0,
  run_no = 0;
end

% initializing in this fashion has benefical effect of establishing that all
% arrays are of the same dimensions, as well as being zero
stream      = zeros (mx, my);
stream_star = zeros (mx, my);
chi         = zeros (mx, my);
zeta_rel    = zeros (mx, my);
u           = zeros (mx, my);
v           = zeros (mx, my);
f_rhs       = zeros (mx, my);
jacobian    = zeros (mx, my);

% initial condtion is zero stream, unless this is a continuation run.
% if it is a continuation then stream should be filled with solution at time tmin 

% alternative: non-zero initial streamfunction
% stream (is,js) = 0.5 * sin(4*pi/lx*X(is,js)).* sin(4*pi/ly*Y(is,js)) ...
%                + 0.5 * sin(1*pi/lx*X(is,js)).* sin(1*pi/ly*Y(is,js));

% initialize kinetic energy and enstrophy time series
energy    = zeros (mt,1);
enstrophy = zeros (mt,1);

return

% eof