function qg_jacobian (stream_in, zeta_in, u_in, v_in) ;

% purpose: calculate jacobain term (from non-linear advective term)
% (see haltiner and williams textbook for details)

% basic variables
qg_globals;

% initalize all jacobians to zero
jacob_pp = zeros (mx,my);
jacob_xp = zeros (mx,my);
jacob_px = zeros (mx,my);
                      
%  J ++ 
if jpp~=0
    jacob_pp (is, js) =((stream     (is+1,js  ) - stream     (is-1,js  ))   ...
                     .* (zeta_in (is  ,js+1) - zeta_in (is  ,js-1))   ...
                      - (stream     (is  ,js+1) - stream     (is  ,js-1))   ...
                     .* (zeta_in (is+1,js  ) - zeta_in (is-1,js  )))  ...
                      / (4*dx^2);
end
        
%  J +x   
if jpx~=0
    jacob_px (is, js) =(stream     (is+1,js  )                          ...
                     .*(zeta_in (is+1,js+1) - zeta_in (is+1,js-1))   ...
                      - stream     (is-1,js  )                          ...
                     .*(zeta_in (is-1,js+1) - zeta_in (is-1,js-1))   ...
                      - stream     (is  ,js+1)                          ...
                     .*(zeta_in (is+1,js+1) - zeta_in (is-1,js+1))   ...
                      + stream     (is  ,js-1)                          ...
                     .*(zeta_in (is+1,js-1) - zeta_in (is-1,js-1)))  ...
                     / (4*dx^2);
end
            
%  J x+
if jxp~=0
   jacob_xp (is,js) =(zeta_in (is  ,js+1)                     ...
                   .*(stream     (is+1,js+1) - stream (is-1,js+1))  ...
                    - zeta_in (is  ,js-1)                     ...
                   .*(stream     (is+1,js-1) - stream (is-1,js-1))  ...
                    - zeta_in (is+1,js  )                     ...
                   .*(stream     (is+1,js+1) - stream (is+1,js-1))  ...
                    + zeta_in (is-1,js  )                     ...
                   .*(stream     (is-1,js+1) - stream (is-1,js-1))) ...
                    /(4*dx^2);
end

% mix it, baby
jacobian (is,js) = jpp * jacob_pp (is,js) ...
                 + jpx * jacob_px (is,js) ...
                 + jxp * jacob_xp (is,js) ; 

return

% eof