function qg_parameters;

% purpose: assign qg parameters

% basic variables
qg_globals;

% stommel, munk, and inertial scales 
% (normalized by basin width lx)
ds = 0.02;
dm = 0.00;
di = 0.02;

% include beta effect (0 is no, 1 is yes)
beta_effect = 1;

% include ekman pumping (0 is no , 1 is yes)
ekman_pumping = 1;

% boundary-condition parameters 
% only necessary for munk solution, i.e., dm is nonzero.
% slip = 0 -> is no-slip (stress)
% slip = 1 -> is yes-slip (no-stress);
slip_w = 0;
slip_e = 0;
slip_s = 0;
slip_n = 0;

% % conserve nothing: set weights for J++, J+x and Jx+  
% jpp =1;          % 1/3; 
% jpx =0;          % 1/3; 
% jxp =1-jpp-jpx;  % takes care that sum = 1 

% conserve enstrophy: set weights for J++, J+x and Jx+  
% jpp =0;          % 1/3; 
% jpx =1;          % 1/3; 
% jxp =1-jpp-jpx;  % takes care that sum = 1 
% 
% % conserve energy: set weights for J++, J+x and Jx+  
% jpp =0;          % 1/3; 
% jpx =0;          % 1/3; 
% jxp =1-jpp-jpx;  % takes care that sum = 1 
% 
% % conserve enstrophy and energy: set weights for J++, J+x and Jx+  
jpp =1/3;          % 1/3; 
jpx =1/3;          % 1/3; 
jxp =1-jpp-jpx;   % takes care that sum = 1 

return

% eof