function qg_plot_ekman

% purpose: plot ekman pumping (but ignore ghost zone values)

% basic variables
qg_globals;

% axes limits
lxi = X (3    ,    3);
lxf = X (end-2,    3);
lyi = Y (3    ,    3);
lyf = Y (3    ,end-3);

% extrema of ekman pumping
w_ekman_max = max( max (w_ekman(is,js)));
w_ekman_min = min( min (w_ekman(is,js)));

% assign ekman pumping plot (in upper-left corner of scrren)
figure(1);
scrsz = get(0,'ScreenSize');

% plot surface
surfc (X (is,js), Y (is,js), w_ekman (is,js));
colorbar;
axis ([lxi lxf lyi lyf -1 1]);

% annotation
xlabel ('x');
ylabel ('y');
zlabel ('w_{ekman}')
title ([' Time = ' num2str(time,2) '     Max(w_{ekman}) = ' num2str(w_ekman_max,2) ...
       '    Min(w_{ekman}) = ' num2str(w_ekman_min,2)]);
drawnow;

% eof