function qg_plot_stream

% purpose: plot stream function but ignoring ghost zone values

% basic variables
qg_globals;

% axes limits (not ghost zone)
lxi = X (2    ,2    );
lxf = X (end-1,2    );
lyi = Y (2    ,2    );
lyf = Y (2    ,end-1);

% extrema of stream function
stream_max = max (max (stream (ib,jb)));
stream_min = min (min (stream (ib,jb)));

% alternative: plot surface
figure (h_fig_stream);
surfc (X (ib,jb), Y (ib,jb), stream (ib,jb));
colorbar;
axis ([lxi lxf lyi lyf -1 1]);

% alternative: plot contours
% figure (h_fig_stream);
% contour (X (ib,jb), Y(ib,jb) ,stream (ib,jb));
% colorbar;
% axis ([lxi lxf lyi lyf]);

% annotation
xlabel ('x');
ylabel ('y');
zlabel ('stream')
title ([' Time = ' num2str(time_now,2) '     Max(stream) = ' num2str(stream_max,2) ...
        '    Min(stream) = ' num2str(stream_min,2)]);
drawnow;

% eof