function qg_plot_stream_ghost;

% purpose: plot stream function including ghost zone values

% basic variables
qg_globals;

% alternative: axes limits (with ghost zone)
lxi = X (1  ,1  );
lxf = X (end,1  );
lyi = Y (1  ,1  );
lyf = Y (1  ,end);

% extrema of stream function
stream_max = max(max(stream (ig,jg)));
stream_min = min(min(stream (ig,jg)));

% open graphcis window
figure;

% plot surface
surfc (X(ig,jg), Y(ig,jg), stream(ig,jg))
colorbar;
axis ([lxi lxf lyi lyf -1 1]);

% annotation
xlabel('x');
ylabel('y');
zlabel('stream')
title([' Time = ' num2str(time_now,2) '     Max(stream) = ' num2str(stream_max,2) ...
        '    Min(stream) = ' num2str(stream_min,2)]);
drawnow;

% eof