function qg_plot_velocity

% purpose: plot velocity but ignore ghost zone values

% basic variables
qg_globals;

% axes limits (not ghost zone)
lxi = X (2    ,2    );
lxf = X (end-1,2    );
lyi = Y (2    ,2    );
lyf = Y (2    ,end-1);

% extrema of velocity function
flow_max = max(sqrt (u(ib,jb).*u(ib,jb) + v(ib,jb).*v(ib,jb)));

% open graphics window
figure (h_fig_veloc);

% plot surface
quiver (X (ib,jb), Y (ib,jb), u (ib,jb), v (ib,jb));
%colorbar;
axis ([lxi lxf lyi lyf]);

% annotation
xlabel('x');
ylabel('y');
zlabel('Velocity')
title([' Time = ' num2str(time_now,2) '     Max(Velocity) = ' num2str(flow_max,2) ]);
drawnow;

% eof