function qg_plot_zeta

% purpose: plot relative vorticity but ignore ghost zone values

% basic variables
qg_globals;

% axes limits (not ghost zone)
lxi = X (2    ,2    );
lxf = X (end-1,2    );
lyi = Y (2    ,2    );
lyf = Y (2    ,end-1);

% extrema of stream function
zeta_max = max(max(zeta_rel (ib,jb)));
zeta_min = min(min(zeta_rel (ib,jb)));

% open graphics window
figure (h_fig_zeta);

% plot surface
surfc (X (ib,jb), Y (ib,jb), zeta_rel (ib,jb))
colorbar;
axis ([lxi lxf lyi lyf -10 10]);

% annotation
xlabel('x');
ylabel('y');
zlabel('psi')
title([' Time = ' num2str(time_now,2) '     Max(zeta) = ' num2str(zeta_max,2) ...
        '    Min(zeta) = ' num2str(zeta_min,2)]);
drawnow;

% eof