function u = qg_poisson_solver (p)

% purpsoe: fast poisson solver with boundary values.
% highly modified version of solver originally written
% by Chuck Denham.

q = p;

% stuff below not need for homogeneous boundary conditions.
% fold the boundary into source terms.
% theFactor = -1;  % Boundary-value scheme.
% for i = 1:2
%	q = q.';
%	q(2:end-1, 2:end-3:end-1) = ...
%		q(2:end-1, 2:end-3:end-1) + ...
%			theFactor * q(2:end-1, 1:end-1:end);
% end

% extract the interior.

q = q (2:end-1, 2:end-1);

% odd-symmetry, sine-transform scheme.

theSign = -1;   

[m, n] = size(q);
q = [zeros(m, 1) q zeros(m, 1) theSign*fliplr(q)];
q = [zeros(1, 2*n+2); q; zeros(1, 2*n+2); theSign*flipud(q)];

% fast poisson transform on square cell grid 
% (dx^2 factor already multiplies p).

[mm, nn] = size (q);
i = (0:mm-1).' * ones(1, nn);
j = ones (mm, 1) * (0:nn-1);
weights = 2 * (cos (2*pi*i/mm) + cos (2*pi*j/nn) - 2);
weights (1, 1) = 1;
pp = ifft2 (fft2 (q) ./ weights);
if isreal (q), pp = real(pp); end

% retain relevant piece.

u = p;
u (2:end-1, 2:end-1) = pp (2:m+1, 2:n+1);

return

% eof
