% purpose: plot results of a run (after the run is over).
% sequentially reads and plots the qg_run_no.mat files.
% basic run data is in the file qg_forcing_fdata.mat.

% basic variables
qg_globals;

% movie paramter
imovie = 0;

load qgdata

[M,N] = size(X);
mx = M-3;
my = N-3;
% ghost points
ig = [1:M];
jg = [1:N];
% boundary points
ib = [2:M-1];
jb = [2:N-1];
% interior solution points
is = [3:M-2];
js = [3:N-2];

%disp(['di = 'num2str(di)])
%disp(['ds = 'num2str(ds)])
%disp(['dm = 'num2str(dm)])

clf
axes('position',[0.1 0.2 0.6 0.6])

for ii = 1:nplot
  load(['qg'num2str(ii)])
  maxpsi = max(max(psi(ib,jb)));
  minpsi = min(min(psi(ib,jb)));
  pcolor(X(ib,jb)',Y(ib,jb)',psi(ib,jb)')
  shading('interp')
  caxis([-0.5 1.3])
%  contourf(X(ib,jb)',Y(ib,jb)',psi(ib,jb)',[0:0.1:1.2])
%  hold on
%  contourf(X(ib,jb)',Y(ib,jb)',psi(ib,jb)',[-1:0.1:-0.1],'--')
%  hold off
  axis('equal')
  axis([0 Lx 0 Ly])
  xlabel('x','fontsize',12)
  ylabel('y','fontsize',12,'rotation',0)
  text(1.05, 1.07,[' t = ' num2str(time)],'fontsize', 12)
%  title([' time = ' num2str(time) '  max(psi) = ' num2str(maxpsi) '  min(psi) = ' num2str(minpsi)],'fontsize', 14)

  text(0.025,1.05,['d_I = 'num2str(di)],'fontsize', 12)
  text(0.35,1.05, ['d_S = 'num2str(ds)],'fontsize', 12)
  text(0.6525,1.05,['d_M = 'num2str(dm)],'fontsize', 12)
  
  drawnow
  if imovie == 1,
     F(:,ii) = getframe;
  end
  
  tt(ii) = time;
  psipt(ii) = psi(5,21);
end

% eof
