function qg_time_step 

% purpose: timestep barotropic qg equation

% do time integration using second-order RK (Huen's) method.
% this requires two evaluations of elliptic problem per time
% step, but is better than standard leapfrog method since it
% avoids sawtooth instability and permits larger time steps.

% basic variables
qg_globals;  
   
for k = 1:1:mt
    
   % update clock
   time_now = t (k);

   % predictor: boundary conditions on streamfunction
    qg_bc (stream (ig,jg)) ;

   % predictor: evaluate rhs of elliptic eqn D^2 chi = f_rhs, where chi is d/dt of  stream
   qg_f_rhs (stream (ig,jg)) ;    

   % predictor: solve elliptic problem
   chi (ib,jb) = qg_poisson_solver (f_rhs (ib,jb)) ;
 
   % predictor: stream_star at new-time
   stream_star (ib,jb) = stream (ib,jb) +  chi (ib,jb) ;
   
   % corrector: boundary conditons on streamfunction
   qg_bc (stream_star (ig,jg)) ;
   
   % corrector: evaluate rhs of elliptic eqn D^2 chi = f_rhs
   qg_f_rhs (stream_star (ig,jg));
      
   % corrector: solve elliptic problem
   chi (ib,jb) = qg_poisson_solver (f_rhs (ib,jb));	      
   
   % corrector: stream at new-time
   stream (ib,jb) = 0.5 * (stream (ib,jb) + stream_star (ib,jb)) ...
               + 0.5 * dt * chi (ib,jb);
           
   % compute kinetic energy and enstrophy
   energy (k) = 0.5 * (sum(sum(u.^2))+sum(sum(v.^2))) / (mx*my);
   enstrophy (k) = 0.5 * sum(sum(zeta_rel.^2)) / (mx*my);     
   
   % perform plotting at desired intervals
           
   if (mod (k, mt_plot) == 0) 

       % plot fields
       qg_plot_stream;
       %qg_plot_zeta;
       qg_plot_velocity;
       
       % save results to disk file named qg_run_no.mat
       file_save = ['qg_runs/qg_run_' num2str(run_no) '_time_' num2str(k) '.mat' ];
       save ( file_save, ...
             'time_now', 'stream', 'zeta_rel', 'u', 'v');
       
   end
 
end

% plot energy and enstrophy time series
qg_plot_energy_enstrophy;

% eof