function qg_velocity (stream_in);

% purpose: compute flow velocities from streamfunction,
% velocities are evalauted using cnetered differencing and thus
% evaluated at same grid points as stream function

% basic variables
qg_globals;

% initialize some arrays
u = zeros (mx, my);
v = zeros (mx, my);

%  velocities (via differentiation of stream function)
u (: ,jb) = -(stream_in (:   ,jb+1) - stream_in (:   ,jb-1)) / (2*dy);
v (ib,: ) =  (stream_in (ib+1,:   ) - stream_in (ib-1,:   )) / (2*dx);

return

% eof